%% Satura??o
h=figure(6); %clf

subplot(211)
plot(y.time,y.signals(1).values,'LineWidth',2)
%axis([0 4 0 3])
legend('c_lin','r','w','c');
xlabel('t/[s]');ylabel('c(t)'),title('Malha Fecada com Saturacao')
grid
subplot(212)
plot(y.time,y.signals(2).values,'LineWidth',2)
legend('u_Sat','u');
xlabel('t/[s]');ylabel('u(t)'),title('Atuador')
%axis([0 4 0 20])
grid
%% Polos Dominantes
h=figure(1); clf

g1=zpk([],[-2-2j -2+2j],8);
g2=zpk([],[-2-2j -2+2j -1],8);
g3=zpk([],[-2-2j -2+2j -2],16);
g4=zpk([],[-2-2j -2+2j -10],80);
g5=zpk([],[-1],1)

[y1,t1]=step(g1);
[y2,t2]=step(g2);
[y3,t3]=step(g3);
[y4,t4]=step(g4);
[y5,t5]=step(g5);



s=sym('s')

g1s=8/(s+2+2j)*(s+2-2j);
g2s=8/((s+2+2j)*(s+2-2j)*(s+1));
g3s=16/((s+2+2j)*(s+2-2j)*(s+2));
g4s=80/((s+2+2j)*(s+2-2j)*(s+10));
g5s=1/(s+1);

ilaplace(1/s*g1s)
ilaplace(1/s*g2s)
ilaplace(1/s*g3s)
ilaplace(1/s*g4s)
ilaplace(1/s*g5s)

plot(t1,y1,'LineWidth',2); hold on
plot(t2,y2,'LineWidth',2)
plot(t3,y3,'LineWidth',2)
plot(t4,y4,'LineWidth',2)
%plot(t5,y5,'LineWidth',2)


legend({'$\displaystyle{G_1(s) = }\frac{8}{(s+2+2j)(s+2-2j)}$',...
            '$\displaystyle{G_2(s) = }\frac{8}{(s+2+2j)(s+2-2j)(s+1)}$',...
            '$\displaystyle{G_3(s) = }\frac{16}{(s+2+2j)(s+2-2j)(s+2)}$',...
            '$\displaystyle{G_4(s) = }\frac{80}{(s+2+2j)(s+2-2j)(s+10)}$'},'Interpreter','latex','FontSize',16)
xlabel('t/[s]'); ylabel('c(t)');title('Resposta ao Degrau Unit?rio')

%% Zeros
h=figure(2); clf

g1=zpk([],[-1 -1],1);
g2=zpk([-5],[-1 -1],.2);
g3=zpk([-.5],[-1 -1],2);
g4=zpk([-.25],[-1 -1],4);

[y1,t1]=step(g1);
[y2,t2]=step(g2);
[y3,t3]=step(g3);
[y4,t4]=step(g4);


s=sym('s')

g1s=1/(s+1)^2;
g2s=0.2*(s+5)/(s+1)^2;
g3s=0.5*(s+2)/(s+1)^2;
g4s=4*(s+0.25)/(s+1)^2;

ilaplace(1/s*g1s)
ilaplace(1/s*g2s)
ilaplace(1/s*g3s)
ilaplace(1/s*g4s)

plot(t1,y1,'LineWidth',2); hold on
plot(t2,y2,'LineWidth',2)
plot(t3,y3,'LineWidth',2)
plot(t4,y4,'LineWidth',2)


legend({'$\displaystyle{G_1(s) = }\frac{1}{(s+1)^2}$',...
            '$\displaystyle{G_2(s) = }\frac{0.2(s+5)}{(s+1)^2}$',...,
            '$\displaystyle{G_3(s) = }\frac{0.5(s+2)}{(s+1)^2}$'...,
            '$\displaystyle{G_4(s) = }\frac{4(s+0.25)}{(s+1)^2}$'},'Interpreter','latex','FontSize',16)
xlabel('t/[s]'); ylabel('c(t)');title('Resposta ao Degrau Unit?rio')

%% Ordem do Sistema
 figure(4)
hold off;

[y1,t1]=step(zpk([],[-1],1));
[y2,t2]=step(zpk([],[-1 -1],1));
[y3,t3]=step(zpk([],[-1 -1 -1],1));
[y4,t4]=step(zpk([],[-1 -1 -1 -1],1));

plot(t1,y1,'LineWidth',2); hold on
plot(t2,y2,'LineWidth',2)
plot(t3,y3,'LineWidth',2)
plot(t4,y4,'LineWidth',2)

legend({'$\displaystyle{G_1(s)=}\frac{1}{s+1}$',...
            '$\displaystyle{G_2(s)=}\frac{1}{(s+1)^2}$',...,
            '$\displaystyle{G_3(s)=}\frac{1}{(s+1)^3}$'...,
            '$\displaystyle{G_4(s)=}\frac{1}{(s+1)^4}$'},'Interpreter','latex','FontSize',16)
xlabel('t/[s]'); ylabel('y');title('Resposta ao Degrau Unit?rio')




%%
s=sym('s')

g1s=1/(s+1)
g2s=1/(s+1)^2
g3s=1/(s+1)^3
g4s=1/(s+1)^4
 
ilaplace(1/s*g1s)
ilaplace(1/s*g2s)
ilaplace(1/s*g3s)
ilaplace(1/s*g4s)
%,g2s,g3s,g4])
 